% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{recover_cache}
\alias{recover_cache}
\title{Load an existing drake files system cache if it exists
or create a new one otherwise.}
\usage{
recover_cache(path = drake::default_cache_path(),
  short_hash_algo = drake::default_short_hash_algo(),
  long_hash_algo = drake::default_long_hash_algo(), force = FALSE,
  verbose = TRUE, fetch_cache = NULL)
}
\arguments{
\item{path}{file path of the cache}

\item{short_hash_algo}{short hash algorithm for the cache.
See \code{\link{default_short_hash_algo}()} and
\code{\link{make}()}}

\item{long_hash_algo}{long hash algorithm for the cache.
See \code{\link{default_long_hash_algo}()} and
\code{\link{make}()}}

\item{force}{logical, whether to load the cache
despite any back compatibility issues with the
running version of drake.}

\item{verbose}{logical, whether to print the file path of the cache.}

\item{fetch_cache}{character vector containing lines of code.
The purpose of this code is to fetch the \code{storr} cache
with a command like \code{storr_rds()} or \code{storr_dbi()},
but customized.}
}
\value{
A drake/storr cache.
}
\description{
Does not work with
in-memory caches such as \code{storr_environment()}.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
clean(destroy = TRUE)
load_basic_example() # Get the code with drake_example("basic").
make(my_plan) # Run the project, build all the targets.
x <- recover_cache(".drake") # Recover the project's storr cache.
})
}
}
\seealso{
\code{\link{new_cache}}, \code{\link{this_cache}},
\code{\link{get_cache}}
}
