% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{readd}
\alias{readd}
\title{Read and return a drake target or import from the cache.}
\usage{
readd(target, character_only = FALSE, path = getwd(), search = TRUE,
  cache = drake::get_cache(path = path, search = search, verbose = verbose),
  namespace = NULL, verbose = TRUE)
}
\arguments{
\item{target}{If \code{character_only} is \code{TRUE},
\code{target} is a character string naming the object to read.
Otherwise, \code{target} is an unquoted symbol with the name of the
object. Note: \code{target} could be the name of an imported object.}

\item{character_only}{logical, whether \code{name} should be treated
as a character or a symbol
(just like \code{character.only} in \code{\link{library}()}).}

\item{path}{Root directory of the drake project,
or if \code{search} is \code{TRUE}, either the
project root or a subdirectory of the project.}

\item{search}{logical. If \code{TRUE}, search parent directories
to find the nearest drake cache. Otherwise, look in the
current working directory only.}

\item{cache}{optional drake cache. See code{\link{new_cache}()}.
If \code{cache} is supplied,
the \code{path} and \code{search} arguments are ignored.}

\item{namespace}{character scalar,
name of an optional storr namespace to read from.}

\item{verbose}{whether to print console messages}
}
\value{
The cached value of the \code{target}.
}
\description{
Does not delete the item from the cache.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
load_basic_example() # Get the code with drake_example("basic").
make(my_plan) # Run the project, build the targets.
readd(reg1) # Return imported object 'reg1' from the cache.
readd(small) # Return targets 'small' from the cache.
readd("large", character_only = TRUE) # Return 'large' from the cache.
# For external files, only the fingerprint/hash is stored.
readd("'report.md'")
})
}
}
\seealso{
\code{\link{loadd}}, \code{\link{cached}},
\code{\link{built}}, \code{link{imported}}, \code{\link{drake_plan}},
\code{\link{make}}
}
