% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/status.R
\name{status}
\alias{status}
\title{Function \code{status}}
\usage{
status(..., list = character(0), imported_files_only = FALSE,
  path = getwd(), search = TRUE)
}
\arguments{
\item{...}{objects to load from the cache, as names (unquoted)
or character strings (quoted). Similar to \code{...} in
\code{\link{remove}(...)}.}

\item{list}{character vector naming objects to be loaded from the
cache. Similar to the \code{list} argument of \code{\link{remove}()}.}

\item{imported_files_only}{logical, applies only when 
no targets are specified and the statuses of cached targets are 
returned.
If \code{imported_files_only} logical, whether to ignore 
imported objects that are not files. If \code{TRUE}, all
targets (with commands in the workflow plan data frame) and
imported files will be listed. Otherwise, everything will be listed.}

\item{path}{Root directory of the drake project,
or if \code{search} is \code{TRUE}, either the
project root or a subdirectory of the project.}

\item{search}{If \code{TRUE}, search parent directories
to find the nearest drake cache. Otherwise, look in the
current working directory only.}
}
\value{
Either the build status of each target given (from the last
call to \code{\link{make}()} or \code{\link{make}()}), or if no 
targets are specified, a data frame containing the build status
of the last session. 
In the latter case, only finished targets are listed.

Either a named logical indicating whether the given
targets or cached or a character vector listing all cached
items, depending on whether any targets are specified
}
\description{
Get the build status (overall or individual targets)
of the last call to 
\code{\link{make}()} or \code{\link{make}()}. 
Objects that drake imported, built, or attempted
to build are listed as \code{"finished"} or \code{"in progress"}. 
Skipped objects are not listed.
}
\seealso{
\code{\link{session}},
\code{\link{built}}, \code{\link{imported}},
\code{\link{readd}}, \code{\link{plan}}, \code{\link{make}}
}
