% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_input.R
\name{time_input}
\alias{time_input}
\alias{update_time_input}
\title{Creates a time input field}
\usage{
time_input(
  id,
  label,
  value = "",
  min = NULL,
  max = NULL,
  format = "HH:mm",
  placeholder = NULL,
  width = NULL,
  color = NULL,
  use_material_picker = FALSE
)

update_time_input(
  session,
  id,
  label = NULL,
  value = NULL,
  min = NULL,
  max = NULL,
  placeholder = NULL
)
}
\arguments{
\item{id}{id of the element}

\item{label}{label to show for the input, NULL for no label}

\item{value}{initial value}

\item{min}{minimum time value, must follow the specified format, e.g. "08:00"}

\item{max}{maximum time value, must follow the specified format, e.g. "17:00"}

\item{format}{format to use for the time string, can be any valid
\href{http://momentjs.com/docs/#/displaying/format/}{moment.js} time
format (NOTE: this will only work with the material time picker and can't be
updated!)}

\item{placeholder}{optional character specifying the placeholder text}

\item{width}{optional, the width of the input, see
\code{\link[shiny:validateCssUnit]{validateCssUnit}}}

\item{color}{color of the watch hand (of material time picker)}

\item{use_material_picker}{boolean to specify if the input should be a
simple time (text) input or use the bootstrap material time picker}

\item{session}{the shiny session object}
}
\value{
time_input: shiny input element

update_time_input: message to the client
}
\description{
time_input creates a time input field for correctly formatted
time values

update_time_input changes the value/label or placeholder of an
time input element on the client side.
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

library(shiny)
shinyApp(
  ui = fluidPage(
    fluidRow(
      column(3,
        time_input("time1", "Simple:", value = "12:34"),
        time_input("time2", "Fancy:", use_material_picker = TRUE),
        actionButton("update", "Update")
      )
    )
  ),
  server = function(input, output, session) {
    observeEvent(input$update, {
      update_time_input(session, "time2", value = "12:34")
    })
  }
)

}
}
\author{
richard.kunze
}
