% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datapackage_install.R
\name{datapackage_install}
\alias{datapackage_install}
\title{Install a data package}
\usage{
datapackage_install(path, load_file, full_meta = FALSE, ...)
}
\arguments{
\item{path}{character string path to the data package directory. Can be a
local directory or a URL. If a URL is given the package will be installed
in the current working directory. If the file is compressed
then it currently must be \code{.zip}-ped.}

\item{load_file}{character string specifying the path of the data file to
load into R. The correct file paths will be printed when the function runs.
By default the first file in the datapackage.json path list is
loaded.
Note: only one file can be loaded at a time.}

\item{full_meta}{logical. Wheter or not to return the full datapackage.json
metadata. Note: when \code{TRUE} only the meta data is returned not the data.}

\item{...}{arguments to pass to \code{\link{import}}.}
}
\description{
Install a data package
}
\examples{
\dontrun{
# Load a data package called gdp stored in the current working directory:
gdp_data = datapackage_install(path = 'gdp')

# Install the gdp data package from GitHub using its .zip URL
URL <- 'https://github.com/datasets/gdp/archive/master.zip'
gdp_data <- datapackage_install(path = URL)

# Install co2 data
library(dplyr)
co2_data <- "https://github.com/datasets/co2-ppm/archive/master.zip" \%>\%
         datapackage_install()
}
}

