% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/lead-lag.R
\name{lead-lag}
\alias{lag}
\alias{lead}
\alias{lead-lag}
\title{Lead and lag.}
\usage{
lead(x, n = 1L, default = NA, order_by = NULL, ...)

lag(x, n = 1L, default = NA, order_by = NULL, ...)
}
\arguments{
\item{x}{a vector of values}

\item{n}{a postive integer of length 1, giving the number of positions to
lead or lag by}

\item{default}{value used for non-existant rows. Defaults to \code{NA}.}

\item{order_by}{override the default ordering to use another vector}

\item{...}{Needed for compatibility with lag generic.}
}
\description{
Lead and lag are useful for comparing values offset by a constant (e.g. the
previous or next value)
}
\examples{
lead(1:10, 1)
lead(1:10, 2)

lag(1:10, 1)
lead(1:10, 1)

x <- runif(5)
cbind(ahead = lead(x), x, behind = lag(x))

# Use order_by if data not already ordered
df <- data.frame(year = 2000:2005, value = (0:5) ^ 2)
scrambled <- df[sample(nrow(df)), ]

wrong <- mutate(scrambled, prev = lag(value))
arrange(wrong, year)

right <- mutate(scrambled, prev = lag(value, order_by = year))
arrange(right, year)
}

