% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TreeFunctions.R
\name{collapseNodes}
\alias{collapseNodes}
\title{Collapse internal nodes with the same predicted sequence}
\usage{
collapseNodes(trees, tips = FALSE, check = TRUE)
}
\arguments{
\item{trees}{a tibble of \code{airrClone} objects, the output of \link{getTrees}}

\item{tips}{collapse tips to internal nodes? (experimental)}

\item{check}{check that collapsed nodes are consistent with original tree}
}
\value{
A tibble with \code{phylo} objects that have had internal nodes collapsed.
}
\description{
\code{collapseNodes} Node collapsing function.
}
\details{
Use plotTrees(trees)[[1]] + geom_label(aes(label=node)) + geom_tippoint() to show
node labels, and getSeq to return internal node sequences
}
\seealso{
\link{getTrees}
}
