% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova.dcca.R
\name{anova.dcca}
\alias{anova.dcca}
\title{Community- and Species-Level Permutation Test in Double Constrained 
Correspondence Analysis (dc-CA)}
\usage{
\method{anova}{dcca}(object, ..., permutations = 999, by = c("omnibus", "axis"))
}
\arguments{
\item{object}{an object from \code{\link{dc_CA}}.}

\item{...}{unused.}

\item{permutations}{a list of control values for the permutations for 
species and sites (species first, sites second, for traits and environment) 
as returned by the function \code{\link[permute]{how}}, or the number of 
permutations required (default 999, or a two-vector with the number for the
species-level test first and that for the sites-level second), or
a list of two permutation matrices (again, species first, sites second)
where each row gives the permuted indices.}

\item{by}{character \code{"axis"} which performs a series of tests, one for
each axis, with the eigenvalue of the axis as test statistic. 
Default: \code{NULL} which sets the test statistic to the inertia
(sum of all double constrained eigenvalues; named \code{constraintsTE} in 
the inertia element of \code{\link{dc_CA}}. 

The interpretation of this inertia is, at the species-level, the 
environmentally constrained inertia explained by the traits (without trait
covariates) and, at the community-level, the trait-constrained inertia
explained by the environmental predictors (without covariates). The 
default (\code{NULL}) is computationally quicker as it avoids computation 
of an svd of permuted data sets.}
}
\value{
A list of 3 of structures as from \code{\link[vegan]{anova.cca}}. The 
elements are \code{c("species", "sites", "maxP")}
}
\description{
\code{anova.dcca} performs the community- and species-level permutation tests
of dc-CA and combines these with the 'max test', which takes the maximum of
the \emph{P}-values. The function arguments are similar to (but more 
restrictive than) those of \code{\link[vegan]{anova.cca}}.
}
\details{
In the general case of varying site abundance totals 
(\code{divideBySiteTotals = FALSE}) both the community-level test and the
species-level test use residualized predictor permutation (ter Braak 2022), 
so as to ensure that \code{\link{anova.dcca}} is robust against differences
in species and site total abundance in the \code{response} (ter Braak & te 
Beest, 2022). The community-level test uses \code{\link{anova_sites}}. For 
the species-level test, \code{\link{anova_species}} is used.

With equal site weights, obtained with \code{divide.by.site.total = TRUE},
the community-level test is obtained by applying \code{anova} to 
\code{object$RDAonEnv} using \code{\link[vegan]{anova.cca}}.
This performs residualized response permutation which performs about equal
to residualized predictor permutation in the equi-weight case.
The function \code{\link[vegan]{anova.cca}} is implemented in C and therefore
a factor of 20 or so quicker than the native R-code used in 
\code{\link{anova_sites}}.
}
\examples{
data("dune_trait_env")

# rownames are carried forward in results
rownames(dune_trait_env$comm) <- dune_trait_env$comm$Sites

mod <- dc_CA(formulaEnv = ~ A1 + Moist + Mag + Use + Manure,
             formulaTraits = ~ SLA + Height + LDMC + Seedmass + Lifespan,
             response = dune_trait_env$comm[, -1],  # must delete "Sites"
             dataEnv = dune_trait_env$envir,
             dataTraits = dune_trait_env$traits,
             verbose = FALSE)
anova(mod)

a_species <- anova_species(mod)
a_species
# anova_species can be used for manual forward selection of
# trait variables, as done for environmental variables in the demo 
# dune_FS_dcCA.r, based on the first eigenvalue and its significance
# and adding the first axis of the constrained species scores from mod to 
# the Condition of a new mod.
(eig1_and_pval <- c(eig = a_species$eig[1], pval = a_species$table$`Pr(>F)`[1]))
a_species$eig
anova_sites(mod)
}
\references{
ter Braak, C.J.F. & te Beest, D.E. 2022. Testing environmental effects
on taxonomic composition with canonical correspondence analysis:
alternative permutation tests are not equal.
Environmental and Ecological Statistics. 29 (4), 849-868.
\doi{10.1007/s10651-022-00545-4}

ter Braak, C.J.F. (2022) Predictor versus response permutation
for significance testing in weighted regression and redundancy analysis.
Journal of statistical computation and simulation, 92, 2041-2059.
\doi{10.1080/00949655.2021.2019256}
}
