% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centrality.R
\name{estimate_centrality_threshold}
\alias{estimate_centrality_threshold}
\title{estimate_centrality_threshold}
\usage{
estimate_centrality_threshold(graph, tolerance = 0.001)
}
\arguments{
\item{graph}{'data.frame' or equivalent object representing the network
graph (see Details)}

\item{tolerance}{Desired maximal degree of inaccuracy in centrality estimates
\itemize{
\item values will be accurate to within this amount, subject to a constant
scaling factor. Note that threshold values increase non-linearly with
decreasing values of 'tolerance'
}}
}
\value{
A single value for 'dist_threshold' giving the required tolerance.
}
\description{
Estimate a value for the 'dist_threshold' parameter of the
\link{dodgr_centrality} function. Providing distance thresholds to this
function generally provides considerably speed gains, and results in
approximations of centrality. This function enables the determination of
values of 'dist_threshold' corresponding to specific degrees of accuracy.
}
\note{
This function may take some time to execute. While running, it displays
ongoing information on screen of estimated values of 'dist_threshold' and
associated errors. Thresholds are progressively increased until the error is
reduced below the specified tolerance.
}
