% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flows.R
\name{merge_directed_flows}
\alias{merge_directed_flows}
\title{merge_directed_flows}
\usage{
merge_directed_flows(graph)
}
\arguments{
\item{graph}{A graph containing a \code{flow} column as returned from
\link{dodgr_flows_aggregate} or \link{dodgr_flows_disperse}}
}
\value{
An equivalent graph in which all directed edges have been reduced to
single, undirected edges, and all directed flows aggregated to undirected
flows.
}
\description{
The \link{dodgr_flows_aggregate} and \link{dodgr_flows_disperse} functions
return a column of aggregated flows directed along each edge of a graph, so
the aggregated flow from vertex A to vertex B will not necessarily equal that
from B to A, and the total flow in both directions will be the sum of flow
from A to B plus that from B to A. This function converts a directed graph to
undirected form through reducing all pairs of directed edges to a single
edge, and aggregating flows from both directions.
}
\examples{
graph <- weight_streetnet (hampi)
from <- sample (graph$from_id, size = 10)
to <- sample (graph$to_id, size = 5)
to <- to [!to \%in\% from]
flows <- matrix (10 * runif (length (from) * length (to)),
                 nrow = length (from))
graph <- dodgr_flows_aggregate (graph, from = from, to = to, flows = flows)
# graph then has an additonal 'flows` column of aggregate flows along all
# edges. These flows are directed, and can be aggregated to equivalent
# undirected flows on an equivalent undirected graph with:
graph_undir <- merge_directed_flows (graph)
# This graph will only include those edges having non-zero flows, and so:
nrow (graph); nrow (graph_undir) # the latter is much smaller
}
