% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_parsing.R
\name{get_lines_between_tags}
\alias{get_lines_between_tags}
\title{Cut Code Chunks From a File}
\usage{
get_lines_between_tags(
  file_name,
  keep_tagged_lines = TRUE,
  begin_pattern = "ROXYGEN_START",
  end_pattern = "ROXYGEN_STOP",
  from_first_line = TRUE,
  to_last_line = TRUE
)
}
\arguments{
\item{file_name}{The name of the R code file to be parsed.}

\item{keep_tagged_lines}{Keep tagged lines output?}

\item{begin_pattern}{A pattern that marks the line beginning a
\pkg{roxygen2}
chunk.}

\item{end_pattern}{A pattern that marks the line ending a \pkg{roxygen2}
chunk.}

\item{from_first_line}{Use first line as tagged line if first tag found
matches the \code{end_pattern}?}

\item{to_last_line}{Use last line as tagged line if last tag found matches
the \code{begin_pattern}?}
}
\value{
A character vector of matching lines.
}
\description{
Get all lines between tagged lines. The tagged lines themselves may be in- or
excluded from the selection.
}
\note{
If you know the file to contain valid \pkg{roxygen2} code only, you do
not
need to tag any lines if you keep from_first_line and to_last_line both TRUE:
in this case the whole file will be returned.
}
\keyword{internal}
