% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\encoding{UTF-8}
\name{Dsensitivity}
\alias{Dsensitivity}
\title{D Sensitivity}
\usage{
Dsensitivity(A = NULL, parNames = NULL, defaults = list(x = NULL, desw =
  NULL, desx = NULL, mod = NULL))
}
\arguments{
\item{A}{for \itemize{
\item D-optimality: \code{NULL}
\item D_s-optimality: a vector of names or indices, the subset of parameters of interest.
\item D_A-optimality: either \itemize{
  \item directly: a matrix without row names.
  \item indirectly: a matrix with row names corresponding to the parameters.
  }
}}

\item{parNames}{a vector of names or indices, the subset of parameters to use.
Defaults to the parameters for which the Fisher information is available.}

\item{defaults}{a named list of default values.
The value \code{NULL} is equivalent to absence.}
}
\value{
\code{Dsensitivity} returns \code{function(x=NULL, desw=NULL, desx=NULL, mod=NULL)}, the sensitivity function.
It's attributes contain this function's arguments.
}
\description{
\code{Dsensitivity} builds a sensitivity function for the D-, D_s or D_A-optimality criterion which relies on defaults to speed up evaluation.
\code{Wynn} for instance requires this behaviour/protocol.
}
\details{
Indices and rows of an unnamed matrix supplied to argument \code{A} correspond to the subset of parameters defined by argument \code{parNames}.

For efficiency reasons the returned function won't complain about \emph{missing arguments} immediately, leading to strange errors.
Please ensure that all arguments are specified at all times.
This behaviour might change in future releases.
}
\examples{
## see examples for param

}
\references{
E. Perrone & W.G. Müller (2016) Optimal designs for copula models, Statistics, 50:4, 917-929, DOI: 10.1080/02331888.2015.1111892
}
\seealso{
\code{\link{docopulae}}, \code{\link{param}}, \code{\link{Wynn}}, \code{\link{plot.desigh}}
}
