% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{plot.desigh}
\alias{plot.desigh}
\title{Plot Design}
\usage{
\method{plot}{desigh}(x, sensx = NULL, sens = NULL, sensTol = NULL, ...,
  margins = NULL, desSens = T, sensPch = "+", sensArgs = list())
}
\arguments{
\item{x}{a design.}

\item{sensx}{(optional) a row matrix of points.}

\item{sens}{(optional) either a vector of sensitivities or a sensitivity function.
The latter shall rely on defaults, see \code{\link{Dsensitivity}} for details.}

\item{sensTol}{(optional) a single numeric.
Adds a horizontal line at this sensitivity level.}

\item{...}{other arguments passed to plot.}

\item{margins}{a vector of indices, the dimensions to project on.
Defaults to \code{1}.}

\item{desSens}{if \code{TRUE} and \code{sens} is not specified then the sensitivity function which potentially was used in \code{Wynn} is taken as \code{sens}.}

\item{sensPch}{either a character vector of point 'characters' to add to the sensitivity curve or \code{NULL}.}

\item{sensArgs}{a list of arguments passed to draw calls related to the sensitivity.}
}
\description{
\code{plot.desigh} creates a one-dimensional design plot, optionally together with a specified sensitivity curve.
If the design space has additional dimensions, the design is projected on a specified margin.
}
\examples{
## see examples for param

}
\references{
uses add.alpha from \url{http://www.magesblog.com/2013/04/how-to-change-alpha-value-of-colours-in.html}
}
\seealso{
\code{\link{design}}, \code{\link{Dsensitivity}}
}

