% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linest_utilities.R
\name{is-estimable}
\alias{is-estimable}
\alias{is_estimable}
\title{Determines if contrasts are estimable.}
\usage{
is_estimable(K, null.basis)
}
\arguments{
\item{K}{A matrix.}

\item{null.basis}{A basis for a null space (can be found with
\code{null_basis()}).}
}
\value{
A logical vector.
}
\description{
Determines if contrasts are estimable, that is, if the contrasts
    can be written as a linear function of the data.
}
\details{
Consider the setting \eqn{E(Y)=Xb}. A linear function of \eqn{b},
    say \eqn{l'b} is estimable if and only if there exists an \eqn{r} such
    that \eqn{r'X=l'} or equivalently \eqn{l=X'r}. Hence \eqn{l} must be in
    the column space of \eqn{X'}, i.e. in the orthogonal complement of the
    null space of \eqn{X}. Hence, with a basis \eqn{B} for the null space,
    \code{is_estimable()} checks if each row \eqn{l} of the matrix \eqn{K} is
    perpendicular to each column basis vector in \eqn{B}.
}
\examples{

## TO BE WRITTEN

}
\references{
\url{http://web.mit.edu/18.06/www/Essays/newpaper_ver3.pdf}
}
\seealso{
\code{\link{null_basis}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{utilities}
