% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dna.R
\name{summary.dnapath}
\alias{summary.dnapath}
\title{Summary function for 'dnapath' object.}
\usage{
\method{summary}{dnapath}(object, by_gene = TRUE, alpha = 1, monotonized = FALSE, ...)
}
\arguments{
\item{object}{A 'dnapath' object from \code{\link{dnapath}}.}

\item{by_gene}{If TRUE, summarizes the differential network analysis by genes;
otherwise, summarizes by gene-gene interactions.}

\item{alpha}{Threshold for p-values to determine significance; defaults
to 1 and returns all results. If 'by_gene'
is FALSE, then 'alpha' is used to filter edges. If 'by_gene' is TRUE,
then 'alpha' is used to filter genes.}

\item{monotonized}{If TRUE, monotonized p-values are used.}

\item{...}{Additional arguments are ignored.}
}
\value{
Summarizes the differential network analysis result.
}
\description{
Summary function for 'dnapath' object.
}
\examples{
data(meso)
data(p53_pathways)
set.seed(0)
results <- dnapath(x = meso$gene_expression, pathway_list = p53_pathways,
                   group_labels = meso$groups, n_perm = 10)
summary(results[[1]]) # Summary of the first pathway in the results.
}
\seealso{
\code{\link{summarize_genes}}, \code{\link{summarize_edges}}
}
