% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dna.R
\name{dna_pathway}
\alias{dna_pathway}
\title{Differential network analysis on a single pathway}
\usage{
dna_pathway(
  x,
  pathway,
  group_prob,
  network_inference,
  permutations,
  lp = 2,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{x}{The gene expression data to be analyzed. Assumed to already be
processed by \code{\link{dnapath}}}

\item{pathway}{A single vector containing gene names.}

\item{group_prob}{A matrix with number of rows equal to the
number of rows in \code{x} and two columns, each containing the probability that
a given observation belongs to each group.}

\item{network_inference}{A function used to infer the pathway network.}

\item{permutations}{A matrix containing the permutations to perform during
permutation testing. If \code{NULL}, the permutation tests are not performed.}

\item{lp}{The lp value used to compute differential connectivity
scores. (Note: If a vector is provided, then the results are returned as
a list of \code{dnapath_list} objects, one result for each value of \code{lp}. This
option is available so that network inference methods only need to be run
once for each pathway when multple values of \code{lp} are being considered. This
may be useful when conducting simulation studies).}

\item{verbose}{Set to TRUE to turn on messages.}

\item{...}{Additional arguments are passed into the network inference function.}
}
\value{
A list containing the results of the differential network analysis
for a single pathway.
}
\description{
This is an internal function used by \code{\link{dnapath}} to conduct
the differential network analysis on a single pathway.
}
\keyword{internal}
