% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reactome.R
\name{symbol_to_entrez}
\alias{symbol_to_entrez}
\title{Obtain entrezgene IDs for gene symbols}
\usage{
symbol_to_entrez(x, species, dir_save = tempdir(), verbose = TRUE)
}
\arguments{
\item{x}{A vector of gene symbols.}

\item{species}{The species used to obtain the entrezgene IDs. For example:
"Homo sapiens", "m musculus", "C. elegans", or "S cerevisiae".
"Human" and "mouse" can also be used and will be converted to the
correct species name.}

\item{dir_save}{The directory to store annotation reference. Future
calls to this function will use the stored annotations. This speeds up the
operation and allows for reproducibility in the event that the \code{biomaRt}
database is updated. Set to NULL to disable. By default, it uses a
temporary directory to store files during the R session.}

\item{verbose}{Set to FALSE to avoid messages.}
}
\value{
A data frame with two columns: the first contains the original
gene symbols, and the second contains a corresponding entrezgene ID.
}
\description{
Uses \code{biomaRt} \insertCite{biomart}{dnapath}
to map entrezgene IDs to gene symbols for a given species. The output of
this function can be used in \code{\link{rename_genes}}.
}
\details{
If entrezgene IDs are used in a \code{dnapath_list} or \code{dnapath}
object, or a pathway list, then \code{\link{get_genes}} can be used to
extract them and used for the \code{x} argument here.
}
\note{
Internet connection is required to connect to biomaRt. If unavailable, the
default biomart and default species contained in the package is used, but
this may not match the desired species.

It is assumed that \code{x} contains MGI symbols when the biomart species is
"Mus musculus" and HGNC symbols otherwise.
}
\examples{
\donttest{
# Convert a set of gene symbols to entrezgene IDs.
# Note that not all may have mapping (such as "MSX" in this example).
gene_mat <- symbol_to_entrez(c("SOX2", "SEMA3E", "COL11A1", "UBB", "MSX"),
                             species = "human")
}
}
\references{
\insertRef{biomart}{dnapath}
}
\seealso{
\code{\link{entrez_to_symbol}}, \code{\link{get_genes}}
}
