% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr-src.R
\name{dplyr_src}
\alias{dplyr_src}
\alias{dm_get_src}
\alias{tbl.dm}
\alias{src_tbls.dm}
\alias{copy_to.dm}
\title{dm as data source}
\usage{
dm_get_src(x)

\method{tbl}{dm}(src, from, ...)

\method{src_tbls}{dm}(x, ...)

\method{copy_to}{dm}(
  dest,
  df,
  name = deparse(substitute(df)),
  overwrite = FALSE,
  temporary = TRUE,
  repair = "unique",
  quiet = FALSE,
  ...
)
}
\arguments{
\item{src}{A \code{dm} object.}

\item{from}{A length one character variable containing the name of the requested table}

\item{...}{See original function documentation}

\item{dest}{For \code{copy_to.dm()}: The \code{dm} object to which a table should be copied.}

\item{df}{For \code{copy_to.dm()}: A table (can be on a different \code{src})}

\item{name}{For \code{copy_to.dm()}: See \code{\link[dplyr:copy_to]{dplyr::copy_to}}}

\item{overwrite}{For \code{copy_to.dm()}: See \code{\link[dplyr:copy_to]{dplyr::copy_to}}; \code{TRUE} leads to an error}

\item{temporary}{For \code{copy_to.dm()}: If the \code{dm} is on a DB, the copied version of \code{df} will only be written temporarily to the DB.
After the connection is reset it will no longer be available.}

\item{repair, quiet}{Name repair options; cf. \code{\link[vctrs:vec_as_names]{vctrs::vec_as_names()}}}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

These methods are deprecated because of their limited use,
and because the notion of a "source" seems to be getting phased out from dplyr.
Use other ways to access the tables in a \code{dm}.
}
\details{
Use \code{\link[=dm_get_con]{dm_get_con()}} instead of \code{dm_get_src()} to get the DBI connetion for a
\code{dm} object

Use \code{\link[base:Extract]{[[}} instead of \code{tbl()} to access individual tables in a \code{dm} object.

Get the names from \code{\link[=dm_get_tables]{dm_get_tables()}} instead of calling \code{dm_get_src()}
to list the table names in a \code{dm} object.

Use \code{\link[=copy_to]{copy_to()}} on a table and then \code{\link[=dm_add_tbl]{dm_add_tbl()}} instead of \code{copy_to()}
on a \code{dm} object.
}
\keyword{internal}
