% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter-dm.R
\name{dm_filter}
\alias{dm_filter}
\alias{dm_apply_filters}
\alias{dm_apply_filters_to_tbl}
\title{Filtering}
\usage{
dm_filter(dm, table, ...)

dm_apply_filters(dm)

dm_apply_filters_to_tbl(dm, table)
}
\arguments{
\item{dm}{A \code{dm} object.}

\item{table}{A table in the \code{dm}.}

\item{...}{Logical predicates defined in terms of the variables in \code{.data}, passed on to \code{\link[dplyr:filter]{dplyr::filter()}}.
Multiple conditions are combined with \code{&} or \verb{,}.
Only the rows where the condition evaluates
to \code{TRUE} are kept.

The arguments in ... are automatically quoted and evaluated in the context of
the data frame. They support unquoting and splicing.
See \code{vignette("programming", package = "dplyr")}
for an introduction to these concepts.}
}
\value{
For \code{dm_filter()}: an updated \code{dm} object (filter executed for given table, and condition stored).

For \code{dm_apply_filters()}: an updated \code{dm} object (filter effects evaluated for all tables).

For \code{dm_apply_filters_to_tbl()}, a table.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#questioning}{\figure{lifecycle-questioning.svg}{options: alt='[Questioning]'}}}{\strong{[Questioning]}}

Filtering a table of a \code{\link{dm}} object may affect other tables that are connected to it
directly or indirectly via foreign key relations.

\code{dm_filter()} can be used to define filter conditions for tables using syntax that is similar to \code{\link[dplyr:filter]{dplyr::filter()}}.
These conditions will be stored in the \code{\link{dm}}, and executed immediately for the tables that they are referring to.

With \code{dm_apply_filters()}, all tables will be updated according to the filter conditions and the foreign key relations.

\code{dm_apply_filters_to_tbl()} retrieves one specific table of the \code{dm} that is updated according to the filter conditions and the foreign key relations.
}
\details{
The effect of the stored filter conditions on the tables related to the filtered ones is only evaluated
in one of the following scenarios:
\enumerate{
\item Calling \code{dm_apply_filters()} or \code{compute()} (method for \code{dm} objects) on a \code{dm}: each filtered table potentially
reduces the rows of all other tables connected to it by foreign key relations (cascading effect), leaving only the rows
with corresponding key values.
Tables that are not connected to any table with an active filter are left unchanged.
This results in a new \code{dm} class object without any filter conditions.
\item Calling \code{dm_apply_filters_to_tbl()}: the remaining rows of the requested table are calculated by performing a sequence
of semi-joins (\code{\link[dplyr:filter-joins]{dplyr::semi_join()}}) starting from each table that has been filtered to the requested table
(similar to 1. but only for one table).
}

Several functions of the {dm} package will throw an error if filter conditions exist when they are called.
}
\section{Life cycle}{

These functions are marked "questioning" because it feels wrong
to tightly couple filtering with the data model.
On the one hand, an overview of active filters is useful
when specifying the base data set for an analysis in terms of column selections
and row filters.
However, these filter condition should be only of informative nature
and never affect the results of other operations.
We are working on formalizing the semantics of the underlying operations
in order to present them in a cleaner interface.

Use \code{\link[=dm_zoom_to]{dm_zoom_to()}} and \code{\link[dplyr:filter]{dplyr::filter()}} to filter rows without registering
the filter.
}

\examples{
\dontshow{if (rlang::is_installed("nycflights13")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
dm_nyc <- dm_nycflights13()
dm_nyc_filtered <-
  dm_nycflights13() \%>\%
  dm_filter(airports, name == "John F Kennedy Intl")

dm_apply_filters_to_tbl(dm_nyc_filtered, flights)

dm_nyc_filtered \%>\%
  dm_apply_filters()

# If you want to keep only those rows in the parent tables
# whose primary key values appear as foreign key values in
# `flights`, you can set a `TRUE` filter in `flights`:
dm_nyc \%>\%
  dm_filter(flights, 1 == 1) \%>\%
  dm_apply_filters() \%>\%
  dm_nrow()
# note that in this example, the only affected table is
# `airports` because the departure airports in `flights` are
# only the three New York airports.
\dontshow{\}) # examplesIf}
\dontshow{if (rlang::is_installed("nycflights13")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

dm_nyc \%>\%
  dm_filter(planes, engine \%in\% c("Reciprocating", "4 Cycle")) \%>\%
  compute()
\dontshow{\}) # examplesIf}
}
