% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table-surgery.R
\name{reunite_parent_child}
\alias{reunite_parent_child}
\alias{reunite_parent_child_from_list}
\title{Merge two tables that are linked by a foreign key relation}
\usage{
reunite_parent_child(child_table, parent_table, id_column)

reunite_parent_child_from_list(list_of_parent_child_tables, id_column)
}
\arguments{
\item{child_table}{Table (possibly created by \code{decompose_table()}) that references \code{parent_table}}

\item{parent_table}{Table (possibly created by \code{decompose_table()}).}

\item{id_column}{Identical name of referencing / referenced column in \code{child_table}/\code{parent_table}.}

\item{list_of_parent_child_tables}{Cf arguments \code{child_table} and \code{parent_table} from
\code{reunite_parent_child()}, but both in a named list (as created by \code{decompose_table()}).}
}
\value{
A wide table produced by joining the two given tables.
}
\description{
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#questioning'><img src='figures/lifecycle-questioning.svg' alt='Questioning lifecycle'></a>}}{\strong{Questioning}}

Perform table fusion by combining two tables by a common (key) column, and then removing this column.

\code{reunite_parent_child()}: After joining the two tables by the column \code{id_column}, this column will be removed.
The transformation is roughly the
inverse of what \code{decompose_table()} does.

\code{reunite_parent_child_from_list()}: After joining the two tables
by the column \code{id_column}, \code{id_column} is removed.

This function is almost exactly the inverse of \code{decompose_table()} (the order
of the columns is not retained, and the original row names are lost).
}
\section{Life cycle}{

These functions are marked "questioning" because they feel more useful
when applied to a table in a dm object.
}

\examples{
decomposed_table <- decompose_table(mtcars, new_id, am, gear, carb)
ct <- decomposed_table$child_table
pt <- decomposed_table$parent_table

reunite_parent_child(ct, pt, new_id)
reunite_parent_child_from_list(decomposed_table, new_id)
}
\seealso{
Other table surgery functions: 
\code{\link{decompose_table}()}
}
\concept{table surgery functions}
