% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foreign-keys.R
\name{dm_get_fk}
\alias{dm_get_fk}
\title{Foreign key column names}
\usage{
dm_get_fk(dm, table, ref_table)
}
\arguments{
\item{dm}{A \code{dm} object.}

\item{table}{A table in the \code{dm}.}

\item{ref_table}{The table that is referenced from \code{table}.}
}
\value{
A list of character vectors with the column name(s) of \code{table},
pointing to the primary key of \code{ref_table}.
}
\description{
\code{dm_get_fk()} returns the names of the
columns marked as foreign key of table \code{table} with respect to table \code{ref_table} within a \code{\link{dm}} object.
If no foreign key is set between the tables, an empty character vector is returned.
}
\section{Compound keys}{


Currently, keys consisting of more than one column are not supported.
\href{https://github.com/cynkra/dm/issues/3}{This feature} is planned for dm 0.2.0.
Therefore the function may return vectors of length greater than one in the future.
}

\examples{
\dontshow{if (rlang::is_installed("nycflights13")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
dm_nycflights13() \%>\%
  dm_get_fk(flights, airports)
dm_nycflights13(cycle = TRUE) \%>\%
  dm_get_fk(flights, airports)
\dontshow{\}) # examplesIf}
}
\seealso{
Other foreign key functions: 
\code{\link{dm_add_fk}()},
\code{\link{dm_enum_fk_candidates}()},
\code{\link{dm_get_all_fks}()},
\code{\link{dm_has_fk}()}
}
\concept{foreign key functions}
