% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binning.R
\name{plot.performance_bin}
\alias{plot.performance_bin}
\title{Visualize Performance for an "performance_bin" Object}
\usage{
\method{plot}{performance_bin}(x, typographic = TRUE, base_family = NULL, ...)
}
\arguments{
\item{x}{an object of class "performance_bin", usually, a result of a call to performance_bin().}

\item{typographic}{logical. Whether to apply focuses on typographic elements to ggplot2 visualization. 
The default is TRUE. if TRUE provides a base theme that focuses on typographic elements using hrbrthemes package.}

\item{base_family}{character. The name of the base font family to use 
for the visualization. If not specified, the font defined in dlookr is applied. (See details)}

\item{...}{further arguments to be passed from or to other methods.}
}
\value{
A ggplot2 object.
}
\description{
It generates plots for understand frequency, WoE by bins using performance_bin.
}
\details{
The base_family is selected from "Roboto Condensed", "Liberation Sans Narrow",
"NanumSquare", "Noto Sans Korean". If you want to use a different font, 
use it after loading the Google font with import_google_font().
}
\examples{
\donttest{
# Generate data for the example
heartfailure2 <- heartfailure

set.seed(123)
heartfailure2[sample(seq(NROW(heartfailure2)), 5), "creatinine"] <- NA

# Change the target variable to 0(negative) and 1(positive).
heartfailure2$death_event_2 <- ifelse(heartfailure2$death_event \%in\% "Yes", 1, 0)

# Binnig from creatinine to platelets_bin.
breaks <- c(0,  1,  2, 10)
heartfailure2$creatinine_bin <- cut(heartfailure2$creatinine, breaks)

# Diagnose performance binned variable
perf <- performance_bin(heartfailure2$death_event_2, heartfailure2$creatinine_bin) 
perf
summary(perf)

plot(perf)

# Diagnose performance binned variable without NA
perf <- performance_bin(heartfailure2$death_event_2, heartfailure2$creatinine_bin, na.rm = TRUE) 
perf
summary(perf)

plot(perf)
plot(perf, typographic = FALSE)
}

}
\seealso{
\code{\link{performance_bin}}, \code{\link{summary.performance_bin}}, \code{\link{binning_by}}, 
\code{\link{plot.optimal_bins}}.
}
