% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{plot.compare_numeric}
\alias{plot.compare_numeric}
\title{Visualize Information for an "compare_numeric" Object}
\usage{
\method{plot}{compare_numeric}(x, prompt = FALSE, typographic = TRUE, base_family = NULL, ...)
}
\arguments{
\item{x}{an object of class "compare_numeric", usually, a result of a call to compare_numeric().}

\item{prompt}{logical. The default value is FALSE. If there are multiple visualizations to be output, 
if this argument value is TRUE, a prompt is output each time.}

\item{typographic}{logical. Whether to apply focuses on typographic elements to ggplot2 visualization. 
The default is TRUE. if TRUE provides a base theme that focuses on typographic elements using hrbrthemes package.}

\item{base_family}{character. The name of the base font family to use 
for the visualization. If not specified, the font defined in dlookr is applied. (See details)}

\item{...}{arguments to be passed to methods, such as graphical parameters (see par).
However, it does not support.}
}
\description{
Visualize scatter plot included box plots by attribute of compare_numeric class.
}
\details{
The base_family is selected from "Roboto Condensed", "Liberation Sans Narrow",
"NanumSquare", "Noto Sans Korean". If you want to use a different font, 
use it after loading the Google font with import_google_font().
}
\examples{
\donttest{
# Generate data for the example
heartfailure2 <- heartfailure[, c("platelets", "creatinine", "sodium")]

library(dplyr)
# Compare the all numerical variables
all_var <- compare_numeric(heartfailure2)

# Print compare_numeric class object
all_var
  
# Compare the two numerical variables
two_var <- compare_numeric(heartfailure2, sodium, creatinine)

# Print compare_numeric class objects
two_var
  
# plot all pair of variables
plot(all_var)

# plot a pair of variables
plot(two_var)

# plot all pair of variables by prompt
plot(all_var, prompt = TRUE)

# plot a pair of variables not focuses on typographic elements
plot(two_var, typographic = FALSE)
}

}
\seealso{
\code{\link{compare_numeric}}, \code{\link{print.compare_numeric}}, \code{\link{summary.compare_numeric}}.
}
