% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{find_skewness}
\alias{find_skewness}
\title{Finding skewed variables}
\usage{
find_skewness(.data, index = TRUE, value = FALSE, thres = NULL)
}
\arguments{
\item{.data}{a data.frame or a \code{\link{tbl_df}}.}

\item{index}{logical. When representing the information of a skewed variable,
specify whether or not the variable is represented by an index.
Returns an index if TRUE or a variable names if FALSE.}

\item{value}{logical. If TRUE, returns the skewness value
in the individual variable.}

\item{thres}{Returns a skewness threshold value that has an absolute skewness
greater than thres. The default is NULL to ignore the threshold.
but, If value = TRUE, default to 0.5.}
}
\value{
Information on variables including skewness.
}
\description{
Find the numerical variable that skewed variable
that inherits the data.frame or data.frame.
}
\examples{
\dontrun{
# Generate data for the example
carseats <- ISLR::Carseats
carseats[sample(seq(NROW(carseats)), 20), "Income"] <- NA
carseats[sample(seq(NROW(carseats)), 5), "Urban"] <- NA

find_skewness(carseats)

find_skewness(carseats, index = FALSE)

find_skewness(carseats, thres = 0.1)

find_skewness(carseats, value = TRUE)

find_skewness(carseats, value = TRUE, thres = 0.1)

## using dplyr -------------------------------------
library(dplyr)

# Perform simple data quality diagnosis of variables with outliers.
carseats \%>\%
  select(find_skewness(.)) \%>\%
  diagnose()
}
}
\seealso{
\code{\link{find_na}}, \code{\link{find_outliers}}.
}
