% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval_sub_criteria.R
\name{eval_sub_criteria}
\alias{eval_sub_criteria}
\alias{eval_sub_criteria.sub_criteria}
\title{Evaluate a \code{\link{sub_criteria}}.}
\usage{
eval_sub_criteria(x, ...)

\method{eval_sub_criteria}{sub_criteria}(
  x,
  x_pos = seq_len(max(attr_eval(x))),
  y_pos = rep(1L, length(x_pos)),
  check_duplicates = TRUE,
  ...
)
}
\arguments{
\item{x}{\code{[\link{sub_criteria}]}.}

\item{...}{Arguments passed to methods.}

\item{x_pos}{\code{[integer]}. Index of one half of a record pair}

\item{y_pos}{\code{[integer]}. Index of one half of a record pair}

\item{check_duplicates}{\code{[logical]}. If \code{FALSE}, does not check duplicate values. The result of the initial check will be recycled.}
}
\value{
\code{logical}; \code{list}
}
\description{
Evaluate a \code{\link{sub_criteria}}.
}
\examples{
# Consider two attributes
attr_1 <- c(1, 1, 0)
attr_2 <- c(2, 1, 2)

# Test for a match in either attribute
sub_cri_1 <- sub_criteria(attr_1, attr_2)
eval_sub_criteria(sub_cri_1)

# Test for a match in both attributes
sub_cri_2 <- sub_criteria(attr_1, attr_2, operator = "and")
eval_sub_criteria(sub_cri_2)
}
\seealso{
\code{\link{sub_criteria}}; \code{\link{reframe}}
}
