% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rlseries.R
\name{rlseries}
\alias{rlseries}
\title{Log-Series Distribution}
\usage{
rlseries(n, size, fisher_alpha, show_progress = TRUE, check_arguments = TRUE)
}
\arguments{
\item{n}{the number of observations.}

\item{size}{The size of the distribution.}

\item{fisher_alpha}{Fisher's \eqn{\alpha} in the log-series distribution.}

\item{show_progress}{if TRUE, a progress bar is shown during long computations.}

\item{check_arguments}{if \code{TRUE}, the function arguments are verified.
Should be set to \code{FALSE} to save time when the arguments have been checked elsewhere.}
}
\value{
A numeric vector with the random values drawn from the log-series distribution.
}
\description{
Random generation for the log-series distribution.
}
\details{
Fast implementation of the random generation of a log-series distribution
\insertCite{Fisher1943}{divent}.

The complete set of functions (including density, distribution function and quantiles)
can be found in package \emph{sads} but this implementation of the random generation is much faster.

If \code{size} is too large, i.e. \code{size} + 1 can't be distinguished from \code{size} due to rounding,
then an error is raised.
}
\examples{
# Generate a community made of 10000 individuals with alpha=40
size <- 1E4
fisher_alpha <- 40
species_number <- fisher_alpha * log(1 + size / fisher_alpha)
abundances <- rlseries(species_number, size = 1E5, fisher_alpha = 40)
# rcommunity() may be a better choice here
autoplot(rcommunity(1, size = 1E4, fisher_alpha = 40, distribution = "lseries"))
}
\references{
\insertAllCited{}
}
