% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ln_q.R
\name{ln_q}
\alias{ln_q}
\title{Deformed logarithm}
\usage{
ln_q(x, q)
}
\arguments{
\item{x}{A numeric vector or array.}

\item{q}{A number.}
}
\value{
A vector of the same length as \code{x} containing the transformed values.
}
\description{
Calculate the deformed logarithm of order \emph{q}.
}
\details{
The deformed logarithm \insertCite{Tsallis1994}{divent} is defined as
\eqn{\ln_q{x}=\frac{(x^{(1-q)}-1)}{(1-q)}}.

The shape of the deformed logarithm is similar to that of the regular one.
\eqn{\ln_1{x}=\log{x}}.

For \eqn{q>1}, \eqn{\ln_q{(+\infty)}=\frac{1}{(q-1)}}.
}
\examples{
curve(ln_q( 1/ x, q = 0), 0, 1, lty = 2, ylab = "Logarithm", ylim = c(0, 10))
curve(log(1 / x), 0, 1, lty = 1, n =1E4, add = TRUE)
curve(ln_q(1 / x, q = 2), 0, 1, lty = 3, add = TRUE)
legend("topright", 
  legend = c(
    expression(ln[0](1/x)),
    expression(log(1/x)),
    expression(ln[2](1/x))
  ),
  lty = c(2, 1, 3), 
  inset = 0.02
 )

}
\references{
\insertAllCited{}
}
