% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/affinity.R
\name{affinity}
\alias{affinity}
\title{Environmental affinities of taxa}
\usage{
affinity(
  x,
  tax,
  bin,
  env,
  coll = NULL,
  method = "binom",
  alpha = 1,
  reldat = NULL,
  na.rm = FALSE,
  bycoll = FALSE
)
}
\arguments{
\item{x}{\code{(data.frame)} The occurrence dataset containing the taxa with unknown environmental affinities.}

\item{tax}{\code{(character)} The column name of taxon names.}

\item{bin}{\code{(character)} The column name of bin names.}

\item{env}{\code{(character)} The environmental variable of the occurrences.}

\item{coll}{\code{(character)} The column name of collection identifiers (optional). If this is provided, then then the multiple entries of a taxon within the collections will be treated as 1.}

\item{method}{\code{(character)} The method used for affinity calculations. Can be either \code{"binom"} or \code{"majority"}.}

\item{alpha}{\code{(numeric)} The alpha value of the binomial tests. By default binomial testing is off (\code{alpha=1}) and the methods returns that environment as the preferred one, which has the highest likelihood (odds ratio).}

\item{reldat}{\code{(data.frame)} Database with the same structure as \code{x}.  \code{x} is typically a subset of \code{reldat}. If given, the occurrence distribution of \code{reldat} is used 
as the null model of sampling. Defaults to \code{NULL}, which means that \code{x} itself will be used as \code{reldat}.}

\item{na.rm}{\code{(logical)} Should the \code{NA} entries in the relevant columns of \code{x} be omitted automatically?}

\item{bycoll}{\code{(logical)} If set to \code{TRUE}, the number of collections (or samples, in \code{coll}) will be used rather than the number of occurrences.}
}
\value{
A named vector, values corresponding to affinities.
}
\description{
This function will return the preferred environment of the taxa, given the distribution of occurrences.
}
\details{
Sampling patterns have an overprinting effect on the frequency of taxon occurrences in different environments. The environmental affinity (Foote, 2006; Kiessling and Aberhan, 2007; Kiessling and Kocsis, 2015) expresses whether the taxa are more likely to occur in an environment, given the sampling patterns of the dataset at hand. The function returns the likely preferred environment for each taxon as a vector. \code{NA} outputs indicate that the environmental affinity is equivocal based on the selected method.

\strong{The following methods are implemented:}

\code{'majority'}: Environmental affinity will be assigned based on the number of occurrences of the taxon in the different environments, without taking sampling of the entire dataset into account. If the taxon has more occurrences in \emph{environment 1}, the function will return \emph{environment 1} as the preferred habitat. 

\code{'binom'}: The proportion of occurrences of a taxon in \emph{environment 1} and \emph{environment 2} will be compared to a null model, which is based on the distribution of all occurrences from the stratigraphic range of the taxon (in \code{x} or if provided, in \code{reldat}). Then a binomial test is run on with the numbers of the most likely preference (against all else). The \code{alpha} value indicates the significance of the binomial tests, setting \code{alpha} to \code{1} will effectively switch the testing off: if the ratio of occurrences for the taxon is different from the ratio observed in the dataset, an affinity will be assigned. This is the default method. If an environment is not sampled at all in the dataset to which the taxon's occurrences are compared to, the binomial method returns \code{NA} for the taxon's affinity. 

\strong{References}

Foote, M. (2006). Substrate affinity and diversity dynamics of Paleozoic marine animals. Paleobiology, 32(3), 345-366.

Kiessling, W., & Aberhan, M. (2007). Environmental determinants of marine benthic biodiversity dynamics through Triassic–Jurassic time. Paleobiology, 33(3), 414-434.

Kiessling, W., & Kocsis, Á. T. (2015). Biodiversity dynamics and environmental occupancy of fossil azooxanthellate and zooxanthellate scleractinian corals. Paleobiology, 41(3), 402-414.
}
\examples{
data(corals)
# omit values where no occurrence environment entry is present, or where unknown
  fossils<-subset(corals, stg!=95)
  fossilEnv<-subset(fossils, bath!="uk")
# calculate affinities
  aff<-affinity(fossilEnv, env="bath", tax="genus", bin="stg", alpha=1)

}
