% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{check_for_pkg}
\alias{check_for_pkg}
\title{Check if a package is installed}
\usage{
check_for_pkg(package, func = stop)
}
\arguments{
\item{package}{the name of the package to check for}

\item{func}{what should this check call if the package is not installed?
This can be any function, but \code{stop}, \code{warning}, \code{skip}, etc. are likely
candidates (default: \code{stop})}
}
\value{
\code{TRUE} if the package is installed, \code{FALSE} if it is not (invisibly)
}
\description{
Uses \code{requireNamespace()} to check if a package is already installed and
provides options for issuing an error, warning, etc. in case the package is
not installed.
}
\details{
It is only exported for use in examples.
}
\examples{
check_for_pkg("DBI")
check_for_pkg("no-such-package", func = message)
}
\keyword{internal}
