% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeneralisedPareto.R
\name{random.GP}
\alias{random.GP}
\title{Draw a random sample from a GP distribution}
\usage{
\method{random}{GP}(x, n = 1L, ...)
}
\arguments{
\item{x}{A \code{GP} object created by a call to \code{\link[=GP]{GP()}}.}

\item{n}{The number of samples to draw. Defaults to \code{1L}.}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
A numeric vector of length \code{n}.
}
\description{
Draw a random sample from a GP distribution
}
\examples{

set.seed(27)

X <- GP(0, 2, 0.1)
X

random(X, 10)

pdf(X, 0.7)
log_pdf(X, 0.7)

cdf(X, 0.7)
quantile(X, 0.7)

cdf(X, quantile(X, 0.7))
quantile(X, cdf(X, 0.7))
}
