% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SDistribution_Matdist.R
\name{[.Matdist}
\alias{[.Matdist}
\title{Extract one or more Distributions from a Matdist}
\usage{
\method{[}{Matdist}(md, i)
}
\arguments{
\item{md}{\link{Matdist} from which to extract Distributions.}

\item{i}{indices specifying distributions to extract.}
}
\value{
If \code{length(i) == 1} then returns a \link{WeightedDiscrete} otherwise
returns a \link{Matdist}.
}
\description{
Extract a \link{WeightedDiscrete} or \link{Matdist} from a \link{Matdist}.
}
\examples{
m <- as.Distribution(
  t(apply(matrix(runif(200), 20, 10, FALSE,
                  list(NULL, sort(sample(1:20, 10)))), 1,
          function(x) x / sum(x))),
  fun = "pdf"
)
m[1]
m[1:2]
}
