% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/distcomp.R
\name{saveNewComputation}
\alias{saveNewComputation}
\title{Save a computation instance, given the computation definition, associated data and
possibly a data file name to use}
\usage{
saveNewComputation(defn, data, dataFileName = NULL)
}
\arguments{
\item{defn}{the identifier of an already defined computation}

\item{data}{the (local) data to use}

\item{dataFileName}{a file name to use for saving the data. Typically \code{NULL}, this
is only needed when one is using a single opencpu server to behave like multiple
sites in which case the data file name serves to distinguish the site-specific data files.
When it is \code{NULL}, the data file name is taken from the configuration settings}
}
\value{
TRUE if everything goes well
}
\description{
The function \code{saveNewComputation} uses the computation definition to save
a new computation instance. This is typically done for every site that wants to participate
in a computation with its own local data. The function examines the computation definition
and uses the identifier therein to uniquely refer to the computation instance at the site.
This function is invoked (maybe remotely) on the opencpu server by
\code{\link{uploadNewComputation}} when a slave site is being set up
}
\seealso{
\code{\link{uploadNewComputation}}
}

