% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsl_colnames.R
\name{tsl_colnames_clean}
\alias{tsl_colnames_clean}
\title{Clean Column Names in Time Series Lists}
\usage{
tsl_colnames_clean(
  tsl = NULL,
  lowercase = FALSE,
  separator = "_",
  capitalize_first = FALSE,
  capitalize_all = FALSE,
  length = NULL,
  suffix = NULL,
  prefix = NULL
)
}
\arguments{
\item{tsl}{(required, list) Time series list. Default: NULL}

\item{lowercase}{(optional, logical) If TRUE, all names are coerced to lowercase. Default: FALSE}

\item{separator}{(optional, character string) Separator when replacing spaces and dots. Also used to separate \code{suffix} and \code{prefix} from the main word. Default: "_".}

\item{capitalize_first}{(optional, logical) Indicates whether to capitalize the first letter of each name Default: FALSE.}

\item{capitalize_all}{(optional, logical) Indicates whether to capitalize all letters of each name Default: FALSE.}

\item{length}{(optional, integer) Minimum length of abbreviated names. Names are abbreviated via \code{\link[=abbreviate]{abbreviate()}}. Default: NULL.}

\item{suffix}{(optional, character string) String to append to the column names. Default: NULL.}

\item{prefix}{(optional, character string)  String to prepend to the column names. Default: NULL.}
}
\value{
time series list
}
\description{
Uses the function \code{\link[=utils_clean_names]{utils_clean_names()}} to simplify and normalize messy column names in a time series list.

The cleanup operations are applied in the following order:
\itemize{
\item Remove leading and trailing whitespaces.
\item Generates syntactically valid names with \code{\link[base:make.names]{base::make.names()}}.
\item Replaces dots and spaces with the \code{separator}.
\item Coerces names to lowercase.
\item If \code{capitalize_first = TRUE}, the first letter is capitalized.
\item If \code{capitalize_all = TRUE}, all letters are capitalized.
\item If argument \code{length} is provided, \code{\link[base:abbreviate]{base::abbreviate()}} is used to abbreviate the new column names.
\item If \code{suffix} is provided, it is added at the end of the column name using the separator.
\item If \code{prefix} is provided, it is added at the beginning of the column name using the separator.
}
}
\examples{
#generate example data
tsl <- tsl_simulate(cols = 3)

#list all column names
tsl_colnames_get(
  tsl = tsl
)

#rename columns
tsl <- tsl_colnames_set(
  tsl = tsl,
  names = c(
  "New name 1",
  "new Name 2",
  "NEW NAME 3"
  )
)

#check new names
tsl_colnames_get(
  tsl = tsl,
  names = "all"
)

#clean names
tsl <- tsl_colnames_clean(
  tsl = tsl
)

tsl_colnames_get(
  tsl = tsl
)

#abbreviated
tsl <- tsl_colnames_clean(
  tsl = tsl,
  capitalize_first = TRUE,
  length = 6,
  suffix = "clean"
)

tsl_colnames_get(
  tsl = tsl
)
}
\seealso{
Other tsl_management: 
\code{\link{tsl_burst}()},
\code{\link{tsl_colnames_get}()},
\code{\link{tsl_colnames_prefix}()},
\code{\link{tsl_colnames_set}()},
\code{\link{tsl_colnames_suffix}()},
\code{\link{tsl_count_NA}()},
\code{\link{tsl_diagnose}()},
\code{\link{tsl_handle_NA}()},
\code{\link{tsl_join}()},
\code{\link{tsl_names_clean}()},
\code{\link{tsl_names_get}()},
\code{\link{tsl_names_set}()},
\code{\link{tsl_names_test}()},
\code{\link{tsl_ncol}()},
\code{\link{tsl_nrow}()},
\code{\link{tsl_repair}()},
\code{\link{tsl_subset}()},
\code{\link{tsl_time}()},
\code{\link{tsl_to_df}()}
}
\concept{tsl_management}
