% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zoo_smooth_window.R
\name{zoo_smooth_window}
\alias{zoo_smooth_window}
\title{Rolling Window Smoothing of Zoo Time Series}
\usage{
zoo_smooth_window(x = NULL, window = 3, f = mean, ...)
}
\arguments{
\item{x}{(required, zoo object) Time series to smooth Default: NULL}

\item{window}{(optional, integer) Smoothing window width, in number of cases. Default: 3}

\item{f}{(optional, quoted or unquoted function name) Name of a standard or custom function to aggregate numeric vectors. Typical examples are \code{mean}, \code{max},\code{min}, \code{median}, and \code{quantile}. Default: \code{mean}.}

\item{...}{(optional, additional arguments) additional arguments to \code{f}.}
}
\value{
zoo object
}
\description{
Just a fancy wrapper for \code{\link[zoo:rollapply]{zoo::rollapply()}}.
}
\examples{
x <- zoo_simulate()

x_smooth <- zoo_smooth_window(
  x = x,
  window = 5,
  f = mean
)

if(interactive()){
  zoo_plot(x)
  zoo_plot(x_smooth)
}
}
\seealso{
Other zoo_functions: 
\code{\link{zoo_aggregate}()},
\code{\link{zoo_name_clean}()},
\code{\link{zoo_name_get}()},
\code{\link{zoo_name_set}()},
\code{\link{zoo_permute}()},
\code{\link{zoo_plot}()},
\code{\link{zoo_resample}()},
\code{\link{zoo_smooth_exponential}()},
\code{\link{zoo_time}()},
\code{\link{zoo_to_tsl}()},
\code{\link{zoo_vector_to_matrix}()}
}
\concept{zoo_functions}
