% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance.sample.size.R
\name{distance.sample.size}
\alias{distance.sample.size}
\title{Required study size in distance sampling.}
\usage{
distance.sample.size(cv.pct, N = Inf, overdispersion = 2,
  detection.function, theta, mean.detection.prob.value,
  shape.hazard = c("verynarrow", "narrow", "wide"), w, stop = F)
}
\arguments{
\item{cv.pct}{The required cv expressed as a percentage. For example, use cv=15 for a coefficient of variation of 15\%.}

\item{N}{Optional. The total abundance of the objects or animals of interest in the whole region of interest. In practice may not be known, in which either
a rough estimate can be used, or N can be set to infinity (the default) which is equivalent to assuming that the fraction of all animals observed is small.
Setting N to Inf results in an over-estimation (usually slight) of the required sample size.}

\item{overdispersion}{The factor by which the variance of the number of objects observed is inflated due to overdispersion.
Burnham, Anderson and Laake (1985) suggest that a value of 2 may be fairly typical in practice.}

\item{detection.function}{The detection function. Only "halfnormal" and "hazard" (hazard rate) are supported at present.}

\item{theta}{The detection function parameters. A single value for halfnormal, or a vector of two values for hazard rate.}

\item{mean.detection.prob.value}{An optional value specifying the mean detection probability over the range of observation. If this is supplied,
the first element of theta should be set to NA, and theta[1] will be calculated using mean.detection.prob.value and detection.function.}

\item{shape.hazard}{Can be used to specify theta according to 3 preset hazard rate models (the ones used in the simulation in Clark 2016).
If shape.hazard is supplied, detection.function should be "hazard", theta need not be supplied, and w need not be supplied as is set to 1
(results in detection probabilities of 0.1 to 0.15 at w). All three options have an average detection rate of 0.6.}

\item{w}{The maximum range of observation. Objects at distance greater than w from the observer are assumed to never be recorded.}

\item{stop}{Set to T to open a browser window (for debugging purposes)}
}
\value{
A vector with named values giving: the required expected sample size, the required coverage rate (i.e. the proportion P of the region falling within
        distance w of an observer's path), the penalty due to unknown detection parameters when P<<1, and the penalty due to unknown detection parameters for the
        required value of P. The user can then use either the required coverage rate to determine how closely to space transect lines (or how many points to
        select in a point transect study)
}
\description{
Calculates the study size needed to achieve a target coefficient of variation for the abundance estimator in conventional distance sampling.
}
\details{
It may be impossible to achieve the target precision, even if the expected sample size is equal to its maximum possible value of N divided by the mean detection probability.
In this case, missing values are returned for the required sample size and coverage proportion, and a warning is issued.
}
\examples{
distance.sample.size(cv.pct=15,N=1000,detection.function="hazard",shape.hazard="narrow")
}
\references{
Buckland S, Anderson D, Burnham K, Laake J and Borchers D (2001). Introduction to Distance Sampling: Estimating Abundance of Biological Populations. Oxford: Oxford University Press.

Burnham KP, Anderson DR, Laake JL (1985), "Efficiency and bias in strip and line transect sampling". The Journal of Wildlife Management, pp. 1012-1018.

Clark, R. G. (2016), "Statistical efficiency in distance sampling," PLoS One, forthcoming, www.plosone.org
}

