% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.bin.ages.R
\name{get.bin.ages}
\alias{get.bin.ages}
\title{Get time bins ages}
\usage{
get.bin.ages(tree, what = "End", type = "Age", ICS = 2015)
}
\arguments{
\item{tree}{A \code{phylo} object with a \code{$root.time} component}

\item{what}{Which data to output. Can be \code{"Start"}, \code{"End"} (default), \code{"Range"} or \code{"Midpoint"}.}

\item{type}{The type of stratigraphic frame. Can be \code{"Age"} (default), \code{"Eon"}, \code{"Epoch"}, \code{"Era"} or \code{"Period"}.}

\item{ICS}{The reference year of the International Commission on Stratigraphy (default = \code{2015}).}
}
\description{
Gets time bins for a specific tree using stratigraphy
}
\examples{
## Loading the data
data(BeckLee_tree)
data(BeckLee_mat50)

## Getting the stratigraphic data
stratigraphy <- get.bin.ages(BeckLee_tree)

## Making stratigraphic time subsets
chrono.subsets(BeckLee_mat50, tree = BeckLee_tree, method = "discrete",
                time = stratigraphy)

}
\seealso{
\code{\link{chrono.subsets}}
}
\author{
Thomas Guillerme
}
