% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/language.R
\name{\%<-?\%}
\alias{\%<-?\%}
\title{Right-hand side checked assignment
Provides a way to avoid assignment to the left-hand side. If the statement
`\code{value}` is invalid or \code{NULL}, this function will not assign values and nothing happens.}
\usage{
lhs \%<-?\% value
}
\arguments{
\item{lhs}{an object to be assigned to}

\item{value}{value to be checked}
}
\value{
Assign value on the right-hand side to the left-hand side if
\code{value} does exists and is not \code{NULL}
}
\description{
Right-hand side checked assignment
Provides a way to avoid assignment to the left-hand side. If the statement
`\code{value}` is invalid or \code{NULL}, this function will not assign values and nothing happens.
}
\examples{
# Prepare, remove aaa if exists
if(exists('aaa', envir = globalenv(), inherits = FALSE)){
  rm(aaa, envir = globalenv())
}

# aaa will not be assigned. run `print(aaa)` will raise error
aaa \%<-?\% NULL

# Assign
aaa \%<-?\% 1
print(aaa)

# in a list
a = list()
a$e \%<-?\% bbb; print(a$e)
a$e \%<-?\% 2; print(a$e)

}
