% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-inputbindings.R
\name{add_to_session}
\alias{add_to_session}
\title{Store/Get key-value pairs in 'shiny' session}
\usage{
add_to_session(
  session,
  key = "rave_id",
  val = paste(sample(c(letters, LETTERS, 0:9), 20), collapse = ""),
  override = FALSE
)
}
\arguments{
\item{session}{'Shiny' session}

\item{key}{character, key to store}

\item{val}{value to store}

\item{override}{if key exists, whether to overwrite its value}
}
\value{
If session is shiny session, returns current value stored in
session, otherwise returns \code{NULL}
}
\description{
If key is missing, it'll be created, otherwise ignored or
overwritten.
}
