% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics.R
\name{dev_create}
\alias{dev_create}
\title{Create a group of named graphic devices}
\usage{
dev_create(..., env = parent.frame())
}
\arguments{
\item{...}{named expressions to launch devices}

\item{env}{environment to evaluate expressions}
}
\value{
A list of functions to query, control, and switch between devices
}
\description{
Create a group of named graphic devices
}
\examples{
\dontrun{ ## Unix-specific example

# Create multiple named devices
devs <- dev_create(line = X11(), points = x11())

# switch to device named "points"

devs$dev_which('points')
plot(1:10)

# switch to "line" device
devs$dev_switch('line')
plot(1:100, type='l')

# Create another group with conflict name
dev_another <- dev_create(line = X11())

# Query device name with 'line'
dev_another$dev_which('line')  # 4
devs$dev_which('line')  # 2, doesn't conflict with the new groups

dev.list()
# close one or more device
dev_another$dev_off('line')
dev.list()

# close all devices
devs$dev_off()
dev.list()

}
}
