% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallels.R
\name{async_expr}
\alias{async_expr}
\title{Apply R expressions in a parallel way}
\usage{
async_expr(.X, .expr, .varname = "x", envir = parent.frame(),
  .pre_run = NULL, .ncore = future::availableCores(), ...)
}
\arguments{
\item{.X}{a vector or a list to apply evaluation on}

\item{.expr}{R expression, unquoted}

\item{.varname}{variable name representing element of each \code{.X}}

\item{envir}{environment to evaluate expressions}

\item{.pre_run}{expressions to be evaluated before looping.}

\item{.ncore}{number of CPU cores}

\item{...}{passed to \code{future::future}}
}
\value{
a list whose length equals to \code{.X}. The value of each item
returned depends on whether \code{async} is called. See details for workflow.
}
\description{
Apply R expressions in a parallel way
}
\details{
\code{async_expr} uses \code{lapply} and \code{future::future} internally.
Within each loop, an item in \code{".X"} will be assigned to variable \code{"x"}
(defined by \code{".varname"}) and enter the evaluation. During the evaluation,
function \code{async} is provided. Expressions within \code{async} will be
evaluated in another session, otherwise will be evaluated in current session.
Below is the workflow:
\itemize{
  \item Run \code{.pre_run}
  \item For \code{i} in \code{seq_along(.X)}:
  \itemize{
    \item 1. Assign \code{x} with \code{.X[[i]]}, variable name \code{x} is
    defined by \code{.varname}
    \item 2. Evaluate \code{expr} in current session.
    \itemize{
      \item a. If \code{async} is not called, return evaluated \code{expr}
      \item b. If \code{async(aync_expr)} is called, evaluate \code{aync_expr}
      in another session, and return the evaluation results if \code{aync_expr}
    }
  }
}
}
