% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date_yq.R
\name{date_yq}
\alias{date_yq}
\alias{is_date_yq}
\alias{as_date_yq}
\title{A Simple S3-Class for Year-Quarter Dates}
\usage{
date_yq(y, q)

is_date_yq(x)

as_date_yq(x)
}
\arguments{
\item{y}{year}

\item{q}{quarter (optional)}

\item{x}{any R object}
}
\value{
\code{date_yq} returns an object of type \code{date_yq}

\code{is_date_yq} returns \code{TRUE} or \code{FALSE}  depending on whether its
argument is of type \code{date_yq} or not.

\code{as_date_yq} attempts to coerce its argument to \code{date_yq}
}
\description{
A simple data type for storing year-quarter dates in a human readable integer
format, e.g.: 3.Quarter of 2012 is stored as 20123. Supports simple
arithmetic operations such as \code{+} and \code{-} as well formatting.
}
\examples{
date_yq(2013, 3)

as_date_yq(20161)

}
\seealso{
\code{\link[=format.date_yq]{format.date_yq()}}, \code{\link[=seq.date_yq]{seq.date_yq()}}, \code{\link[=date_xx_arithmetic]{date_xx_arithmetic()}}

Other date_xx subclasses: \code{\link{date_ym}},
  \code{\link{date_yw}}
}
\concept{date_xx subclasses}
