% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/wrap_ellipses.R, R/wrap_hull.R
\docType{methods}
\name{wrap}
\alias{wrap}
\alias{wrap_hull}
\alias{wrap_hull-method}
\alias{wrap_confidence}
\alias{wrap_confidence-method}
\alias{wrap_tolerance}
\alias{wrap_tolerance-method}
\alias{wrap_confidence,MultivariateAnalysis-method}
\alias{wrap_tolerance,MultivariateAnalysis-method}
\alias{wrap_hull,MultivariateAnalysis-method}
\title{Wrap Observations}
\usage{
wrap_hull(x, ...)

wrap_confidence(x, ...)

wrap_tolerance(x, ...)

\S4method{wrap_confidence}{MultivariateAnalysis}(x, margin = 1, axes = c(1, 2), group = NULL, level = 0.95)

\S4method{wrap_tolerance}{MultivariateAnalysis}(x, margin = 1, axes = c(1, 2), group = NULL, level = 0.95)

\S4method{wrap_hull}{MultivariateAnalysis}(x, margin = 1, axes = c(1, 2), group = NULL)
}
\arguments{
\item{x}{An object from which to wrap observations (a \code{\linkS4class{CA}},
\code{\linkS4class{MCA}} or \code{\linkS4class{PCA}} object).}

\item{...}{Currently not used.}

\item{margin}{A length-one \code{\link{numeric}} vector giving the subscript which the
data will be returned: \code{1} indicates individuals/rows (the default), \code{2}
indicates variables/columns.}

\item{axes}{A length-two \code{\link{numeric}} vector giving the dimensions
to be for which to compute results.}

\item{group}{A vector specifying the group an observation belongs to.}

\item{level}{A \code{\link{numeric}} vector specifying the confidence/tolerance level.}
}
\value{
\verb{wrap_*()} returns a \code{\link{data.frame}} of envelope \code{x} and \code{y} coordinates.

An extra column named \code{group} is added specifying the group an observation
belongs to.
}
\description{
\itemize{
\item \code{wrap_hull()} computes convex hull of a set of observations.
\item \code{wrap_confidence()} computes a confidence ellipse.
\item \code{wrap_tolerance()} computes a tolerance ellipse.
}
}
\examples{
## Load data
data("iris")

## Compute principal components analysis
X <- pca(iris, scale = TRUE)

## Convex hull coordinates
hulls <- wrap_hull(X, margin = 1, group = iris$Species)

## Confidence ellipse coordinates
conf <- wrap_confidence(X, margin = 1, group = iris$Species,
                        level = c(0.68, 0.95))

## Tolerance ellipse coordinates
conf <- wrap_confidence(X, margin = 1, group = iris$Species, level = 0.95)

## Plot with convex hulls
col <- c("#004488", "#DDAA33", "#BB5566")
viz_rows(X, highlight = iris$Species, col = col)
viz_hull(X, group = iris$Species, border = col)
}
\seealso{
Other plot methods: 
\code{\link{biplot}()},
\code{\link{screeplot}()},
\code{\link{viz_contributions}()},
\code{\link{viz_individuals}()},
\code{\link{viz_variables}()},
\code{\link{viz_wrap}}
}
\author{
N. Frerebeau
}
\concept{plot methods}
