% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importPolarized.r
\name{importPolarized}
\alias{importPolarized}
\title{Imports genomic data polarized according to the specification}
\usage{
importPolarized(file, changePolarity, ChosenInds)
}
\arguments{
\item{file}{character vector with a single path to a file with genotypes.}

\item{changePolarity}{logical vector with length equal to the number of markers.}

\item{ChosenInds}{numeric vector of indices of individuals to be included in the analysis.}
}
\value{
Returns a character matrix with rows containing individual genotypes and columns
containing markers.
}
\description{
Reads genotypes from a file and changes marker polarity.
}
\details{
For details on the input data format, check the \code{file} with
\code{CheckDiemFormat}.

The \code{changePolarity} argument influences how each marker is imported. Value
\code{FALSE} means that the marker will be imported as it is saved in the \code{file}. Value
\code{TRUE} means that the genotypes encoded as \code{0} will be imported as \code{2}, and genotypes
encoded in the \code{file} as \code{2} will be imported as \code{0}.
}
\examples{
dat <- importPolarized(
  file = system.file("extdata", "data6x3.txt", package = "diemr"),
  changePolarity = c(FALSE, TRUE, TRUE),
  ChosenInds = 1:6
)
dat
#    m1  m2  m3
# 1 "0" "1" "2"
# 2 "0" "0" "0"
# 3 "1" "1" "0"
# 4 "1" "2" "0"
# 5 "2" "2" "1"
# 6 "2" "2" "_"
}
\seealso{
\code{\link{diem}} for determining appropriate marker polarity with
respect to a barrier to geneflow.
}
