% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consensus_funs.R
\name{LCA}
\alias{LCA}
\title{Latent Class Analysis}
\usage{
LCA(E, is.relabelled = TRUE, seed = 1)
}
\arguments{
\item{E}{a matrix of clusterings with number of rows equal to the number of
cases to be clustered, number of columns equal to the clustering obtained
by different resampling of the data, and the third dimension are the
different algorithms. Matrix may already be two-dimensional.}

\item{is.relabelled}{logical; if \code{FALSE} the data will be relabelled using
the first clustering as the reference.}

\item{seed}{random seed for reproducibility}
}
\value{
a vector of cluster assignments based on LCA
}
\description{
Combine clustering results using latent class analysis.
}
\examples{
\dontshow{if (rlang::is_installed("poLCA")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(hgsc)
dat <- hgsc[1:100, 1:50]
cc <- consensus_cluster(dat, nk = 4, reps = 6, algorithms = "pam", progress =
FALSE)
table(LCA(cc[, , 1, 1, drop = FALSE], is.relabelled = FALSE))
\dontshow{\}) # examplesIf}
}
\seealso{
Other consensus functions: 
\code{\link{CSPA}()},
\code{\link{LCE}()},
\code{\link{k_modes}()},
\code{\link{majority_voting}()}
}
\author{
Derek Chiu
}
\concept{consensus functions}
