% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consensus_funs.R
\name{LCE}
\alias{LCE}
\title{Linkage Clustering Ensemble}
\usage{
LCE(E, k, dc = 0.8, R = 10, sim.mat = c("cts", "srs", "asrs"))
}
\arguments{
\item{E}{is an array of clustering results. An error is thrown if there are
missing values. \code{\link[=impute_missing]{impute_missing()}} can be used beforehand.}

\item{k}{requested number of clusters}

\item{dc}{decay constant for CTS, SRS, or ASRS matrix}

\item{R}{number of repetitions for SRS matrix}

\item{sim.mat}{similarity matrix; choices are "cts", "srs", "asrs".}
}
\value{
a vector containing the cluster assignment from either the CTS, SRS,
or ASRS similarity matrices
}
\description{
Generate a cluster assignment from a CTS, SRS, or ASRS similarity matrix.
}
\examples{
data(hgsc)
dat <- hgsc[1:100, 1:50]
x <- consensus_cluster(dat, nk = 4, reps = 4, algorithms = c("km", "hc"),
progress = FALSE)
\dontrun{
LCE(E = x, k = 4, sim.mat = "asrs")
}

x <- apply(x, 2:4, impute_knn, data = dat, seed = 1)
x_imputed <- impute_missing(x, dat, nk = 4)
LCE(E = x_imputed, k = 4, sim.mat = "cts")
}
\seealso{
Other consensus functions: \code{\link{CSPA}},
  \code{\link{k_modes}}, \code{\link{majority_voting}}
}
\author{
Johnson Liu
}
