% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dhReg.R
\name{fc}
\alias{fc}
\title{forecast using Dynamic Harmonic Regression}
\usage{
fc(Frequency, XREG_test = NULL, h, Fit, Data)
}
\arguments{
\item{Frequency}{seasonal frequency(can be multiple frequency)}

\item{XREG_test}{independent variable of test data, if any}

\item{h}{how much further to forecast}

\item{Fit}{Model fitted using dhr function}

\item{Data}{a time series data used while building a model}
}
\value{
forecasted values
}
\description{
forecasting the time series data using Dynamic Harmonic Regression
}
\examples{
\donttest{
Data1 <- runif(runif(200,100,1000))#To generate random number for example
Data_ts <- ts(Data1)
M <- dhr(Data=Data_ts,XREG=NULL,Range=list(1:2,1),Frequency=c(24,168),Criteria="aicc")
Fcast <- fc(Frequency = c(24,168), XREG_test = NULL, h = 10, Fit = M, Data = Data_ts)
plot(Fcast)
}
}
