% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.R
\name{update}
\alias{update}
\alias{update.dgp}
\alias{update.gp}
\title{Update a GP or DGP emulator}
\usage{
update(object, X, Y, refit, reset, verb, ...)

\method{update}{dgp}(
  object,
  X,
  Y,
  refit = FALSE,
  reset = FALSE,
  verb = TRUE,
  N = 100,
  cores = 1,
  ess_burn = 10,
  B = NULL,
  ...
)

\method{update}{gp}(object, X, Y, refit = FALSE, reset = FALSE, verb = TRUE, ...)
}
\arguments{
\item{object}{can be one of the following:
\itemize{
\item the S3 class \code{gp}.
\item the S3 class \code{dgp}.
}}

\item{X}{the new input data which is a matrix where each row is an input training data point and each column is an input dimension.}

\item{Y}{the new output data:
\itemize{
\item If \code{object} is an instance of the \code{gp} class, \code{Y} is a matrix with only one column and each row being an output data point.
\item If \code{object} is an instance of the \code{dgp} class, \code{Y} is a matrix with its rows being output data points and columns being
output dimensions. When \code{likelihood} (see below) is not \code{NULL}, \code{Y} must be a matrix with only one column.
}}

\item{refit}{a bool indicating whether to re-fit the emulator \code{object} after the training input and output are updated. Defaults to \code{FALSE}.}

\item{reset}{a bool indicating whether to reset hyperparameters of the emulator \code{object} to their initial values when the emulator was
constructed, after the training input and output are updated. Defaults to \code{FALSE}.}

\item{verb}{a bool indicating if the trace information will be printed during the function execution.
Defaults to \code{TRUE}.}

\item{...}{N/A.}

\item{N}{number of training iterations used to re-fit the emulator \code{object} if it is an instance of the \code{dgp} class. Defaults to \code{100}.}

\item{cores}{the number of cores/workers to be used to re-fit GP components (in the same layer)
at each M-step during the re-fitting. If set to \code{NULL}, the number of cores is set to \verb{(max physical cores available - 1)}.
Only use multiple cores when there is a large number of GP components in different layers and optimization of GP components
is computationally expensive. Defaults to \code{1}.}

\item{ess_burn}{number of burnin steps for the ESS-within-Gibbs at each I-step in training the emulator \code{object} if it is an
instance of the \code{dgp} class. Defaults to \code{10}.}

\item{B}{the number of imputations for predictions from the updated emulator \code{object} if it is an instance of the \code{dgp} class.
This overrides the number of imputations set in \code{object}. Set to \code{NULL} to use the same number of imputations set
in \code{object}. Defaults to \code{NULL}.}
}
\value{
An updated \code{object}.
}
\description{
This function updates the training input and output of a GP or DGP emulator with an option to refit the emulator.
}
\details{
See further examples and tutorials at \url{https://mingdeyu.github.io/dgpsi-R/}.
}
\note{
\itemize{
\item The following slots:
\itemize{
\item \code{loo} and \code{oos} created by \code{\link[=validate]{validate()}};
\item \code{results} created by \code{\link[=predict]{predict()}}; and
\item \code{design} created by \code{\link[=design]{design()}}
}

in \code{object} will be removed and not contained in the returned object.
\item Any R vector detected in \code{X} and \code{Y} will be treated as a column vector and automatically converted into a single-column
R matrix. Thus, if \code{X} is a single data point with multiple dimensions, it must be given as a matrix.
}
}
\examples{
\dontrun{

# See alm(), mice(), pei(), or vigf() for an example.
}
}
