% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-dgirtin.r, R/methods-dgirtin.r
\docType{methods}
\name{dgirtin-class}
\alias{dgirtin-class}
\alias{dgirtin-class,}
\alias{get_item_n,}
\alias{get_item_names,}
\alias{get_n,}
\alias{dgirtIn-method,}
\alias{print.dgirtIn,}
\alias{summary}
\alias{summary,dgirtIn-method}
\alias{print}
\alias{print,dgirtIn-method}
\alias{get_item_names}
\alias{get_item_names,dgirtIn-method}
\alias{get_item_names}
\alias{get_n}
\alias{get_n,dgirtIn-method}
\alias{get_n}
\alias{get_item_n}
\alias{get_item_n,dgirtIn-method}
\alias{get_item_n}
\alias{show,dgirtIn-method}
\title{A class for data ready to model}
\usage{
summary(object, ...)

\S4method{summary}{dgirtIn}(object, ...)

print(x, ...)

\S4method{print}{dgirtIn}(x, ...)

get_item_names(x)

\S4method{get_item_names}{dgirtIn}(x)

get_n(x, by = NULL, aggregate_name = NULL)

\S4method{get_n}{dgirtIn}(x, by = NULL, aggregate_name = NULL)

get_item_n(x, by = NULL, aggregate_data = FALSE)

\S4method{get_item_n}{dgirtIn}(x, by = NULL, aggregate_data = FALSE)

\S4method{show}{dgirtIn}(object)
}
\arguments{
\item{object}{An object of class \code{dgirtIn} as returned by \code{shape}.}

\item{...}{Unused.}

\item{x}{An object of class \code{dgirtIn} as returned by \code{shape}.}

\item{by}{The name of a grouping variable.}

\item{aggregate_name}{If specified \code{get_n} will operate on the table
passed to \code{shape} as \code{aggregate_data} instead of on the individual
data and count nonmissingness in the given variable.}

\item{aggregate_data}{If specified \code{get_item_n} will operate on the table passed
to \code{shape} as \code{aggregate_data} instead of on the individual data.}
}
\value{
A list of item names.
}
\description{
\code{shape()} generates objects of class \code{dgirtIn} for modeling with
\code{dgirt()} and \code{dgmrp()}.
}
\examples{
data(toy_dgirt_in)
get_item_names(toy_dgirt_in)
get_n(toy_dgirt_in)
get_n(toy_dgirt_in, by = "year")
get_n(toy_dgirt_in, by = "source")
get_item_n(toy_dgirt_in)
get_item_n(toy_dgirt_in, by = "year")
data(toy_dgirt_in)
get_item_names(toy_dgirt_in)
# respondent count
data(toy_dgirt_in)
get_n(toy_dgirt_in)

# respondent count by year
get_n(toy_dgirt_in, by = "year")

# respondent count by year and survey identifier
get_n(toy_dgirt_in, by = c("year", "source"))

data(toy_dgirt_in)
get_item_n(toy_dgirt_in)
get_item_n(toy_dgirt_in, by = "year")
}
