% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dggridR.R
\name{dgcellstogrid}
\alias{dgcellstogrid}
\title{Return boundary coordinates for specified cells}
\usage{
dgcellstogrid(dggs, cells, savegrid = NA)
}
\arguments{
\item{dggs}{A dggs object from dgconstruct()}

\item{cells}{The cells to get the boundaries of}

\item{savegrid}{If savegrid is set to a file path, then a shapefile
containing the grid is written to that path and the filename
is returned. No other manipulations are done.
Default: NA (do not save grid, return it)}
}
\value{
Returns an sf object.
        If \code{!is.na(savegrid)}, returns a filename.
}
\description{
Returns the coordinates constituting the boundary of a
                 specified set of cells. Duplicates are eliminated to reduce
                 processing and storage requirements.
}
\examples{
library(dggridR)
data(dgquakes)

#Construct a grid with cells about ~1000 miles wide
dggs          <- dgconstruct(spacing=1000,metric=FALSE)
dgquakes$cell <- dgGEO_to_SEQNUM(dggs,dgquakes$lat,dgquakes$lon)$seqnum

#Get grid cells for the earthquakes identified
grid          <- dgcellstogrid(dggs, dgquakes$cell)
}
