% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miscellaneous.R
\name{idx}
\alias{idx}
\alias{idx.dfidx}
\alias{idx.idx}
\alias{idx.xseries}
\alias{format.idx}
\title{Index for dfidx}
\usage{
idx(x, n = NULL, m = NULL)

\method{idx}{dfidx}(x, n = NULL, m = NULL)

\method{idx}{idx}(x, n = NULL, m = NULL)

\method{idx}{xseries}(x, n = NULL, m = NULL)

\method{format}{idx}(x, size = 4, ...)
}
\arguments{
\item{x}{a \code{dfidx} or a \code{xseries}}

\item{n, m}{\code{n} is the index to be extracted (1 or 2), \code{m} equal to
one to get the index, greater than one to get a nesting
variable.}

\item{size}{the number of characters of the indexes for the format
method}

\item{...}{further arguments (for now unused)}
}
\value{
a \code{data.frame} containing the indexes or a series if a
specific index is selected
}
\description{
The index of a \code{dfidx} is a data.frame containing the different
series which define the two indexes (with possibly a nesting
structure). It is stored as a "sticky" data.frame column of the
data.frame and is also inherited by series (of class \code{'xseries'})
which are extracted from a \code{dfidx}.
}
\details{
idx is defined as a generic with a \code{dfidx} and a \code{xseries}
method.
}
\examples{
mn <- dfidx(munnell, idx = c(region = "state", president = "year"))
idx(mn)
gsp <- mn$gsp
idx(gsp)
# get the first index
idx(mn, 1)
# get the nesting variable of the first index
idx(mn, 1, 2)
}
\author{
Yves Croissant
}
